@echo off
setlocal EnableExtensions EnableDelayedExpansion

REM ==========================================================
REM   ComputeX Miner - UNINSTALL_ALL (One Button)
REM
REM   This removes:
REM     - C:\ComputeX\computex_miner
REM     - C:\ComputeX\docs
REM     - C:\ComputeX\README_FIRST.txt
REM     - computex:// protocol registration (HKCU, and HKLM if present)
REM
REM   NOTES:
REM     - Close any running miner cmd.exe windows first.
REM     - If HKLM protocol key exists, reg delete may require admin.
REM ==========================================================

set "ROOT=C:\ComputeX"
set "TARGET=%ROOT%\computex_miner"

echo ==========================================
echo   ComputeX Miner - UNINSTALL_ALL
echo ==========================================
echo This will remove:
echo   %TARGET%
echo   %ROOT%\docs
echo   %ROOT%\README_FIRST.txt
echo and unregister computex://
echo.

choice /C YN /N /M "Proceed with uninstall? (Y/N): "
if errorlevel 2 (
  echo Cancelled.
  pause
  exit /b 0
)

echo.
echo [1/3] Unregistering computex:// protocol (per-user)...
reg delete "HKCU\Software\Classes\computex" /f >nul 2>nul
if errorlevel 1 (
  echo NOTE: HKCU\Software\Classes\computex not found (or already removed).
) else (
  echo OK: HKCU protocol key removed.
)

echo Checking for system-wide protocol key (may require admin)...
reg delete "HKLM\Software\Classes\computex" /f >nul 2>nul
if errorlevel 1 (
  echo NOTE: HKLM\Software\Classes\computex not removed (not present or requires admin).
) else (
  echo OK: HKLM protocol key removed.
)

echo.
echo [2/3] Removing files...
if exist "%TARGET%" (
  rmdir /S /Q "%TARGET%" >nul 2>nul
)
if exist "%ROOT%\docs" (
  rmdir /S /Q "%ROOT%\docs" >nul 2>nul
)
if exist "%ROOT%\README_FIRST.txt" (
  del /F /Q "%ROOT%\README_FIRST.txt" >nul 2>nul
)

echo.
echo [3/3] Cleanup complete.

echo.
echo ==========================================
echo   DONE
echo ==========================================
echo If a computex:// link still opens, reboot Windows (protocol cache) and try again.
echo.
pause
endlocal
