@echo off
setlocal ENABLEDELAYEDEXPANSION

REM --- resolve folders ---
set "_HERE=%~dp0"
set "_ROOT=%_HERE%\.."
for %%A in ("%_ROOT%") do set "_ROOT=%%~fA"

cd /d "%_HERE%"

REM --- early console banner ---
title ComputeX Miner
echo.
echo ==========================================
echo   ComputeX - Initializing, standby...
echo ==========================================
echo.

REM Optional ASCII banner (ascii-text-art.txt in the same folder)
if exist "%_HERE%ascii-text-art.txt" (
  type "%_HERE%ascii-text-art.txt"
  echo(
)

REM ---------------------------
REM Frontier-only computex://
REM ---------------------------

REM 1) Input URL
set "URL=%~1"
if "!URL!"=="" (
  echo [ERROR] No URL provided. Aborting.
  goto :the_end
)

REM 2) Extract query string after '?'
set "QSTR="
for /f "tokens=2 delims=?" %%A in ("%URL%") do set "QSTR=%%A"

REM 3) Strip any chunk_index param if present
for /f "usebackq delims=" %%S in (`powershell -NoLogo -Command ^
  "$q='%QSTR%';" ^
  "$q=[uri]::UnescapeDataString($q);" ^
  "$q=$q -replace '(?:^|&)(chunk_index=[^&]*)','';" ^
  "$q=$q -replace '&&','&';" ^
  "$q=$q.Trim('&');" ^
  "Write-Output $q"`) do set "QSTR=%%S"

REM 4) Split key/values
set "TMPFILE=%TEMP%\computex_args.txt"
(echo !QSTR!) > "!TMPFILE!"
powershell -NoLogo -Command "(Get-Content '%TMPFILE%') -replace '&', \"`n\" | Set-Content '%TMPFILE%'"

REM 5) Init vars
set "server="
set "miner="
set "job_id="
set "lease_id="

REM 6) Parse keys (frontier-only: ignore chunk_index entirely)
for /f "usebackq delims=" %%P in ("!TMPFILE!") do (
  set "line=%%P"
  if not "!line!"=="" (
    for /f "tokens=1,* delims==" %%K in ("!line!") do (
      set "k=%%K"
      set "v=%%L"
      if /i "!k!"=="server"   set "server=!v!"
      if /i "!k!"=="miner"    set "miner=!v!"
      if /i "!k!"=="job_id"   set "job_id=!v!"
      if /i "!k!"=="lease_id" set "lease_id=!v!"
    )
  )
)

REM 7) URL-decode server and tidy scheme
for /f "delims=" %%D in ('powershell -NoLogo -Command "[uri]::UnescapeDataString('%server%')"') do set "server=%%D"
set "server=!server:http:///=http://!"
set "server=!server:https:///=https://!"

REM 8) Validate requireds
set "fail=0"
if "!server!"==""   set "fail=1" & echo [ERROR] Server value missing from URL!
if "!miner!"==""    set "fail=1" & echo [ERROR] Miner value missing from URL!
if "!job_id!"==""   set "fail=1" & echo [ERROR] Job ID missing from URL!
if "!lease_id!"=="" set "fail=1" & echo [ERROR] Lease ID missing from URL!
if "!fail!"=="1" (
  echo.
  echo [DEBUG] Parsed args file:
  type "!TMPFILE!"
  echo.
  del "!TMPFILE!" 2>nul
  goto :the_end
)

REM 9) Fetch FRONTIER payload (never /chunk)
set "CHUNKFILE=%TEMP%\computex_chunk.json"
curl -s "!server!/jobs/!job_id!/frontier_payload?lease_id=!lease_id!" > "!CHUNKFILE!"

REM 9b) Extract job kind / handler (no echo needed, just for possible future use)
set "JOB_KIND="
for /f "usebackq delims=" %%J in (`powershell -NoLogo -Command ^
  "$json = Get-Content '%CHUNKFILE%' -Raw | ConvertFrom-Json;" ^
  "if ($json.job_kind) { $json.job_kind } elseif ($json.handler) { $json.handler }"`) do set "JOB_KIND=%%J"

REM 10) Choose Python (prefer repo-root venv, then local venv, then py/python)
set "PYEXE="
if exist "%_ROOT%\.venv\Scripts\python.exe" set "PYEXE=%_ROOT%\.venv\Scripts\python.exe"
if not defined PYEXE if exist "%_HERE%\.venv\Scripts\python.exe" set "PYEXE=%_HERE%\.venv\Scripts\python.exe"
if not defined PYEXE for /f "delims=" %%P in ('where py 2^>nul') do set "PYEXE=py"
if not defined PYEXE for /f "delims=" %%P in ('where python 2^>nul') do set "PYEXE=python"
if not defined PYEXE (
  echo [ERROR] Could not locate a Python interpreter.
  goto :the_end
)

REM 11) Script path
set "SCRIPT_PATH=%_HERE%universal_miner.py"

REM 12) Run miner once for this lease (unbuffered so output appears immediately)
call "%PYEXE%" -u "%SCRIPT_PATH%" --server "!server!" --miner "!miner!" --job_id "!job_id!" --lease_id "!lease_id!" --payload_file "!CHUNKFILE!"

REM Cleanup
del "!TMPFILE!" 2>nul
del "!CHUNKFILE!" 2>nul

:the_end
echo.
echo Waiting 15 seconds before closing...
timeout /t 5 /nobreak >nul
endlocal
exit /b %errlevel%
