@echo off
setlocal ENABLEDELAYEDEXPANSION

echo [computex] Registering computex:// protocol handler...

REM --- Resolve absolute folder of this script ---
set "HERE=%~dp0"
for %%A in ("%HERE%") do set "HERE=%%~fA"

REM Ensure trailing backslash
if not "%HERE:~-1%"=="\" set "HERE=%HERE%\"

set "LAUNCHER=%HERE%computex-launcher.bat"

if not exist "%LAUNCHER%" (
  echo [ERROR] Could not find computex-launcher.bat at:
  echo         "%LAUNCHER%"
  echo Make sure this script is in the same folder as computex-launcher.bat.
  goto :done
)

echo [computex] Using launcher: "%LAUNCHER%"

REM --- Write registry keys under HKCU\Software\Classes (user-level) ---
REM This avoids needing full machine admin rights; Windows merges HKCU\Software\Classes into HKCR.

set "BASE=HKCU\Software\Classes\computex"

reg add "%BASE%" /ve /d "URL:ComputeX Protocol" /f >nul
reg add "%BASE%" /v "URL Protocol" /d "" /f >nul

reg add "%BASE%\shell" /ve /d "open" /f >nul
reg add "%BASE%\shell\open" /ve /d "" /f >nul

REM Important: use %%1 so the batch file gets the original URL argument.
reg add "%BASE%\shell\open\command" /ve /d "\"%LAUNCHER%\" \"%%1\"" /f >nul

if errorlevel 1 (
  echo [ERROR] Failed to register protocol in the registry.
  echo Try running this script as Administrator.
) else (
  echo [computex] computex:// protocol registered successfully for this user.
)

:done
echo.
echo Press any key to exit...
pause >nul
endlocal
exit /b
